﻿var panelImportation = {
    page: null,
    groups: []
}

$(document).ready(function () {
    $(".v-panelImport .v-panelsTable").a4datatable({
        height: "full",
        ajaxAction: a4.getAction("GetImports", "Import", "Panel"),
        columns: [
            { "Name": "Id", Title: resources.Id, "Data": "Id", "Type": "numeric", "Width": "5%" },
            { "Name": "Filename", Title: resources.Filename, "Data": "Filename", "Width": "20%" },
            { "Name": "Status", Title: resources.Status, "Data": "StatusName", "Width": "20%" },
            { "Name": "Size", Title: resources.Size, "Data": "Size", "Width": "10%" },
            { "Name": "Group", Title: resources.Group, "Data": "Group", "Width": "20%" },
            { "Name": "ModifiedBy", Title: resources.ModifiedBy, "Data": "ModifiedBy", "Width": "15%" },
            { "Name": "ModifiedOn", Title: resources.ModifiedOn, "Data": "ModifiedOn", "Type": "date", "Width": "10%" },
            { "Name": "CreatedById", Title: resources.CreatedBy, "Data": "CreatedById", "Visible": false }
        ],
        defaultSorting: { Column: "Id", Ascending: false },
        autoUpdate: true,
        contextMenuItems: GetContextMenuItems(),
        contextMenuClick: function (event, data) {
            var row = data.row;
            var action = data.action;
            var self = $(this);

            if (action == "validate") {
                window.location.href = a4.getAction("ValidateImport", "Import", "Panel", { importationId: row.Id });
            }
            else if (action == "delete") {
                DeleteRows([row], self);
            }
            else if (action == "reanalyze") {
                a4.callServerMethod(a4.getAction("ReanalyzeImportation", "Import", "Panel"), { importationId: row.Id }, function (result) {
                    self.a4datatable("refresh");
                });
            }
            else if (action == "viewReport") {
                modalDialog.showWindow(a4.getAction("ImportationReport", "Import", "Panel", { importationId: row.Id }), 800, 700);
            }
            else if (action == "commit") {
                modalDialog.showConfirmDialog(confirmCommitImportationResources, function () {
                    a4.callServerMethod(a4.getAction("CommitImportation", "Import", "Panel"), { importationId: row.Id }, function (result) {
                        self.a4datatable("refresh");
                    });
                }, 250, 500, false, {});
            }
        },
        toolBarItems: GetToolBarItems(),
        toolBarClick: function (event, data) {
            var action = data.action;
            var rows = data.rows;
            var self = $(this);

            if (action == "delete") {
                DeleteRows(rows, self);
            }
        },
        localizableTexts: { "Search": resources.SearchImportPanelists },
        customCallback: function () {
            ToggleLeftPanelInitialization();
        }
    });

    $(".v-panelImport").on("change", ".v-importIntoGroup", function () {
        if (!$(this).is(":checked")) {
            $(".v-groupChooser").val("");
            $(".v-groupChooser").attr("data-value", "0");
            $(".v-groupChooser").a4autocomplete("disable");
        } else {
            $(".v-groupChooser").a4autocomplete("enable");
        }
    });

    $(".v-panelImport").on("click", ".v-addGroupButton", function () {
        modalDialog.showWindow(a4.getAction("AddGroup", "Import", "Panel"), 250, 450);
    });

    $(".v-panelImport").on("click", ".v-importButton", function () {
        $("#dataForm").submit();
        $(".v-importButton").addClass('disabled');
    });

    $(".v-panelImport").on("change", ".v-fileInput", function (e) {
        var files = e.originalEvent.target.files;
        var fileSize = 1;
        var guid = $("#FileGuid").val();
        $(".v-importButton").prop('disabled', true);
        $(".v-importButton").addClass('disabled');
        $(".validation-summary-errors").css("display", "none");
        $(".h-progress").css("width", "0%");
        $("#fileUploadProgress").css("display", "block");
        displayFileName(files);
        if (files) {
            var file = files[0];
            if (file) {
                if (file.size / (1024 * 1024) > maxFileSize) {  //Compare in MB
                    a4.showErrorMessage(errorMessageForFileSizeLimit);
                    displayFileName(false);
                    return;
                }
                a4.callFileFormDataServerMethod(a4.getAction("ImportUploadFile", "Import", "Panel"), file, { guid: guid },
                    function (result, position) {

                        var progressPercent = Math.trunc((position / file.size) * 100);
                        $(".h-progress").css("width", progressPercent.toString() + "%");
                        $(".h-progress-percent").text(Math.trunc((position / file.size) * 100) + "%");
                        $("#uploadCompletedText").css('display', 'none');

                    }, function (result) {
                        $(".h-progress-percent").text("100%");
                        $("#FileName").val(file.name);
                        $(".v-importButton").prop('disabled', false);
                        $(".v-importButton").removeClass('disabled');
                        $(".h-progress").css("width", "100%");
                        $("#uploadCompletedText").css('display', '');

                    }, function (result) {
                        $("#fileUploadProgress").css("display", "none");
                        $("#validation-error").css("display", "block");
                        $("#validation-error-message").text(result.responseJSON.Message);
                        displayFileName(false);
                    });
                fileSize = file.size / 1024; //converts bytes to KB
            }
        }
    });

    SetGroupAutoComplete();

    $("input").on("keypress", function (e) { return (e.keyCode != 13); });
    
    $('.remove-item').on('click', function () {
        $('#file').val('');
        displayFileName(false);
    });

    $("input[name='PanelistImportationType']").on("change", function () {
        if (this.value == 'UpdateExisting') {
            $("input#importIntoGroup").prop('disabled', true);
            $("input#importIntoGroup").prop("checked", false);
            $(".v-groupChooser").val("");
            $(".v-groupChooser").attr("data-value", "0");
            $(".v-groupChooser").a4autocomplete("disable");
            $("#iButtonText").html(iButtontooltipTextForUpdateExisting);
        }
        else {
            $("input#importIntoGroup").prop('disabled', false);
            $("#iButtonText").html(iButtontooltipTextForImportNew);
        }
    });
});

function DeleteRows(rows, dataTable) {
    // Cannot delete analyzing or commiting status
    var processingState = _.find(rows, function (r) { return r.Status == 0 || r.Status == 3 });

    if (processingState != null) {
        a4.showErrorMessage(importPageTexts.DeleteStateConflict);
    }
    else {
        modalDialog.showConfirmDialog(importPageTexts, function () {
            a4.callServerMethod(a4.getAction("DeleteSelected", "Import", "Panel"), { ids: _.pluck(rows, "Id") }, function (result) {
                dataTable.a4datatable("refresh");
            },
                function (error) {
                    var message = eval("(" + error.responseText + ")").Message;
                    a4.showErrorMessage(message);
                });
        }, 250, 500, true, { "count": rows.length });
    }
}

function ReloadGroupAutocomplete() {
    $(".v-groupChooser").a4autocomplete("clearCache");
}

function GetContextMenuItems() {
    var items = Array();

    items.push({ "Action": "viewReport", "Label": importPageTexts.ViewReport, "DisplayCondition": function (data) { return _.contains([1, 2, 3, 4, 5], data.Status); } });

    if (canValidateImport) {
        var displayCondition = function (data) {
            var userAllow = !canReadPII ? userId == data.CreatedById : true;

            return _.contains([1, 2], data.Status) && userAllow;
        }

        items.push({
            "Action": "validate", "Label": importPageTexts.Validate,
            "DisplayCondition": displayCondition
        });

        items.push({
            "Action": "delete", "Label": resources.Delete,
        });
    }

    if (canCommitImport) {
        items.push({ "Action": "commit", "Label": importPageTexts.Commit, "DisplayCondition": function (data) { return data.Status == 2; } });
    }

    return items;
}

function GetToolBarItems() {
    var items = Array();

    if (canDeleteImport) {
        items.push({ "Action": "delete", "Label": resources.Delete });
    }

    return items;
}

function SetGroupAutoComplete() {

    $(".v-groupChooser").a4autocomplete({
        ajaxAction: a4.getAction("GetGroups", "Import", "Panel"),
        select: function (event, ui) {
            $(".v-selectedGroup").val(ui.item.Value);
            return false;
        },
    });

    $(".v-groupChooser").a4autocomplete("disable");
}

function displayFileName(files) {

    if (files && files.length > 0) {
        var file = files[0];
        $(".file-name-section").text(file.name);
        $(".remove-item").removeClass('hideItem')
    }
    else {
        $('#file').val('');
        $(".file-name-section").text(importPageTexts.NoFileChosen);
        $(".remove-item").addClass('hideItem');
        $(".v-importButton").prop('disabled', true);
        $("#fileUploadProgress").css("display", "none");
    }
}

function ToggleLeftPanelInitialization() {
    if (!$('#showLeftPart').length)
    {
        $("div.toolBar").parent().prepend(
            `<button id="showLeftPart" class="toggle-respondent-filter-show hideItem">
                         <span class="fa fa-ellipsis-v"></span >
             </button >`
        );
    }

    $(document).on('click', '.toggle-option-section', function () {
        $('.panelistfilter-right-section').css('width', '98%');
        $('.panelistfilter-left-section').addClass('hideItem');
        $('.dataTables_scrollHeadInner').toggleClass('width-100');
        $('.dataTables_scrollHeadInner .compact.dataTable.no-footer').toggleClass('width-100');
        $('.toggle-respondent-filter-show').removeClass('hideItem');
    });

    $(document).on('click', '.toggle-respondent-filter-show', function () {
        $('.panelistfilter-right-section').css('width', '');
        $('.panelistfilter-left-section').removeClass('hideItem');
        $('.dataTables_scrollHeadInner').toggleClass('width-100');
        $('.dataTables_scrollHeadInner .compact.dataTable.no-footer').toggleClass('width-100');
        $('.toggle-respondent-filter-show').addClass('hideItem');
    });

}